result = sys.msgbox("ntScrubber Starting!", "ntScrubber", MB_TYPEOKCANCEL, MB_ICONEXCLAMATION)
if result == "cancel" then
      print("User Cancelled")
      sys.msgbox("ntScrubber Cancelled!", "ntScrubber", MB_TYPEOK, MB_ICONEXCLAMATION)
      os.exit(1)
end

os_ver = sys.os()
spool_processor_dir = "w32x86"
if string.match(os_ver.processor, "x32") then
   spool_processor_dir = "w32x86"
   print("Detected x32 OS")
else
   if string.match(os_ver.processor, "x64") then
      spool_processor_dir = "x64"
      print("Detected x64 OS")
   else
      print("Unsupported OS")
      os.exit(1)
   end
end

device_enumerator_list = 
{
  "USBPRINT\\Hewlett-PackardHP_LaserJet_Professional_M1132_MFP",
  "USBPRINT\\Hewlett-PackardHP_LaserJet_Professional_M1134_MFP",
  "USBPRINT\\Hewlett-PackardHP_LaserJet_Professional_M1136_MFP",
  "USBPRINT\\Hewlett-PackardHP_LaserJet_Professional_M1137_MFP",
  "USBPRINT\\Hewlett-PackardHP_LaserJet_Professional_M1138_MFP",
  "USBPRINT\\Hewlett-PackardHP_LaserJet_Professional_M1139_MFP",
  "USBPRINT\\Hewlett-PackardHP_LaserJet_Professional_M1212nf_MFP",
  "USBPRINT\\Hewlett-PackardHP_LaserJet_Professional_M1213nf_MFP",
  "USBPRINT\\Hewlett-PackardHP_LaserJet_Professional_M1214nfh_MFP",
  "USBPRINT\\Hewlett-PackardHP_LaserJet_Professional_M1216nfh_MFP",
  "USBPRINT\\Hewlett-PackardHP_LaserJet_Professional_M1217nfw_MFP",
  "USBPRINT\\Hewlett-PackardHP_LaserJet_Professional_M1218nf_MFP",  
  "USBPRINT\\Hewlett-PackardHP_LaserJet_Professional_M1219nf_MFP",
  
  "USBSTOR\\CdRom&Ven_HP&Prod_Smart_Install&Rev_1.0",
  
  "USB\\Vid_03f0&Pid_042a", 
  "USB\\Vid_03f0&Pid_052a",
  "USB\\Vid_03f0&Pid_0e2a",
}

printer_driver_list = 
{
  "HP LaserJet Professional M1132 MFP",
  "HP LaserJet Professional M1134 MFP",
  "HP LaserJet Professional M1136 MFP",
  "HP LaserJet Professional M1137 MFP",
  "HP LaserJet Professional M1138 MFP",
  "HP LaserJet Professional M1139 MFP",

  "HP LaserJet Professional M1212nf MFP",
  "HP LaserJet Professional M1213nf MFP",
  "HP LaserJet Professional M1214nfh MFP",
  "HP LaserJet Professional M1216nfh MFP",
  "HP LaserJet Professional M1217nfw MFP",
  "HP LaserJet Professional M1218nf MFP",
  "HP LaserJet Professional M1219nf MFP",
}

print_processor_list = 
{
  "HPM1210PrintProc",
}

print_monitor_list = 
{
  "HPM1210LM",
}

oem_inf_section_list = 
{
  "HPM1130",
  "HPM1210",
}

filepath_cleanup_list =
{
  string.format("%s\\spool\\drivers\\%s\\3\\hpm1210sd.dll", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\hpm1210su.dll", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\hpm1210su.ent", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\hpm1210su.ver", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\hpm1130sd.sdd", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\hpm1210sd.sdd", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\hpm1210sd.chm", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\HPM1210PP.dll", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\HPM1210GC.DLL", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\M1210TestPage.prn", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\M1130TestPage.prn", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  
  string.format("%s\\spool\\drivers\\%s\\hpm1210sd.dll", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\hpm1210su.dll", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\hpm1210su.ent", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\hpm1210su.ver", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\hpm1130sd.sdd", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\hpm1210sd.sdd", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\hpm1210sd.chm", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\HPM1210PP.dll", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\HPM1210GC.DLL", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\M1210TestPage.prn", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\M1130TestPage.prn", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),  


  string.format("%s\\spool\\prtprocs\\%s\\HPM1210PP.DLL", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  
  string.format("%s\\hpm1210sd.dll", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\hpm1210su.dll", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\hpm1210su.ent", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\hpm1210su.ver", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\hpm1130sd.sdd", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\hpm1210sd.sdd", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\hpm1210sd.chm", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\HPM1210PP.dll", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\HPM1210GC.DLL", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\M1210TestPage.prn", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\M1130TestPage.prn", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir), 

  string.format("%s\\system32\\HPM1210LM.DLL", sys.folderpath(CSIDL_WINDOWS)),
  string.format("%s\\system32\\HPM1210SMs.dll", sys.folderpath(CSIDL_WINDOWS)),
  string.format("%s\\system32\\HPM1210SM.exe", sys.folderpath(CSIDL_WINDOWS)),  
  string.format("%s\\system32\\HPSIsvc.exe", sys.folderpath(CSIDL_WINDOWS)),  

  string.format("%s\\mvtcpui.ini", sys.folderpath(CSIDL_WINDOWS)),
  string.format("%s\\system32\\mvhlewsi.dll", sys.folderpath(CSIDL_WINDOWS)),
  string.format("%s\\system32\\mvtcpmon.dll", sys.folderpath(CSIDL_WINDOWS)),
  string.format("%s\\system32\\mvtcpui.dll", sys.folderpath(CSIDL_WINDOWS)),
  string.format("%s\\system32\\mvusbews.dll", sys.folderpath(CSIDL_WINDOWS)),
  string.format("%s\\system32\\slp32.dll", sys.folderpath(CSIDL_WINDOWS)),
  string.format("%s\\system32\\slp64.dll", sys.folderpath(CSIDL_WINDOWS)),
  string.format("%s\\system32\\slpconf.xml", sys.folderpath(CSIDL_WINDOWS)),

  string.format("%s\\system32\\drivers\\mvusbews.sys", sys.folderpath(CSIDL_WINDOWS)),
}

folderpath_cleanup_list =
{
  string.format("%s\\spool\\drivers\\%s\\Hewlett-PackardHP_La037F", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\Hewlett-PackardHP_La03F7", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\Hewlett-PackardHP_LaC38E", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\Hewlett-PackardHP_La03B3", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\Hewlett-PackardHP_La02E7", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\Hewlett-PackardHP_LaC2DA", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  
  string.format("%s\\spool\\drivers\\%s\\Hewlett-PackardHP_La4063", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\Hewlett-PackardHP_LaE272", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\Hewlett-PackardHP_La5E20", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\Hewlett-PackardHP_La8481", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\Hewlett-PackardHP_La2875", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\Hewlett-PackardHP_La22C8", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\Hewlett-PackardHP_LaE2D8", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),  

  string.format("%s\\HP\\HP LaserJet M1210 MFP Series", sys.folderpath(CSIDL_PROGRAM_FILES)),
}

registry_cleanup_list =
{
  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional M1132 MFP",
  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional M1134 MFP",
  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional M1136 MFP",
  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional M1137 MFP",
  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional M1138 MFP",
  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional M1139 MFP",

  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional M1212nf MFP",
  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional M1213nf MFP",
  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional M1214nfh MFP",
  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional M1216nfh MFP",
  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional M1217nfw MFP",
  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional M1218nf MFP",
  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional M1219nf MFP",
  
  HKEY_CURRENT_USER,  "SOFTWARE\\Hewlett-Packard\\HPLJ1210 SM",
}


--
-- turn on verbose messaging
--
verbose(true)


--
-- Uninstall HP LaserJet Professional M1210 Series Software
--
print(string.format("Attempt to run HP LaserJet M1210 MFP Series Software Uninstaller"))
commandline = string.format("%s\\HP\\HP LaserJet M1210 MFP Series\\UnInstall.exe", sys.folderpath(CSIDL_PROGRAM_FILES))
print(string.format("Running M1210 MFP Series Software Uninstaller = %s", commandline))
if (sys.exist(commandline)) then
   proc.execute(commandline)
   print(string.format("Waiting for UnInstall.exe to complete..."))
   while (proc.pid("UnInstall.exe") > 0) do
      sys.wait(1000)      
   end
else
   print(string.format("  **Could not find %s", commandline))
end


--
-- Stop HPSIP1100Service
--
print("Stopping HP SI Service")
if service.stop("HP SI Service", 15000) == 0 then
  print("  **Failed to stop HP SI Service**")
end

--
-- Delete HP SI Service
--
print("Deleting HP SI Service")
if service.delete("HP SI Service") == 0 then
  print("  **Failed to delete HP SI Service**")
end


--
-- Stop Spooler
--
print("Stopping spooler")
if service.stop("spooler", 15000) == 0 then
  print("  **Failed to stop spooler**")
end

--
-- Uninstall Driver Package
--
infpath = string.format("%s\\HP\\HP LaserJet M1210 MPF Series\\HPM1210.INF", sys.folderpath(CSIDL_PROGRAM_FILES))
print(string.format("Attempt to Uninstall Driver Package for: %s", infpath))
if device.dpuninst(infpath) == 0 then
  print(string.format("  **Failed to uninstall driver package**"))
end


--
-- Remove Device(s) 
--
function func_remove_devices(enumName)
  print(string.format("Removing devices with enumerator = %s", enumName))
  if device.pnpremove(enumName, true, true) == 0 then
    print("  **Failed to remove all devices**")
  end
end

i=1
while (i <= #device_enumerator_list) do
  func_remove_devices(device_enumerator_list[i])
  i = i + 1
end


--
-- Remove any dangling OEM INFs
--
function oeminf_files(filename, status)
  if (status == 0) then
    i=1
    while (i <= #oem_inf_section_list) do
      if (device.infisvalid(filename, oem_inf_section_list[i]) == 1) then
        print(string.format("Removing device INF file = %s", filename))
        if (device.infremove(filename, oem_inf_section_list[i]) == 0) then
          print("  **Failed to remove device INF file**")
        end
      end
      i = i + 1
    end
  end

  return 1
end

print(string.format("Attempting to remove any dangling OEM INFs"))
wininfdir = string.format("%s\\inf",sys.windir())
sys.forfiles(wininfdir, "oem*.inf", 0, oeminf_files)


--
-- Start Spooler
--
print("Starting spooler")
if service.start("spooler", 15000) == 0 then
  print("  **Failed to start spooler**")
end


--
-- Remove Printer(s)
--
function func_remove_printers(driverName)
  print(string.format("Removing printers using driver = %s", driverName))
  if printer.removeprinters(driverName) == 0 then
    print("  **Failed to remove all printers**")
  end
end

i=1
while (i <= #printer_driver_list) do
  func_remove_printers(printer_driver_list[i])
  i = i + 1
end


--
-- Remove Printer Driver(s)
--
function func_remove_drivers(driverName)
  print(string.format("Removing printer driver = %s", driverName))
  if printer.removedrivers(driverName) == 0 then
    print("  **Failed to remove printer driver**")
  end
end

i=1
while (i <= #printer_driver_list) do
  func_remove_drivers(printer_driver_list[i])
  i = i + 1
end


--
-- Remove Print Processor(s)
--
function func_remove_processors(processorName)
  print(string.format("Removing print processor = %s", processorName))
  if printer.removeprintprocessors(processorName) == 0 then
    print("  **Failed to remove print processor**")
  end
end

i=1
while (i <= #print_processor_list) do
  func_remove_processors(print_processor_list[i])
  i = i + 1
end


--
-- Remove Print Monitor(s)
--
function func_remove_monitors(monitorName)
  print(string.format("Removing monitor = %s", monitorName))
  if printer.removemonitors(monitorName) == 0 then
    print("  **Failed to remove monitor**")
  end
end

i=1
while (i <= #print_monitor_list) do
  func_remove_monitors(print_monitor_list[i])
  i = i + 1
end


--
-- Stop Spooler
--
print("Stopping spooler")
if service.stop("spooler", 15000) == 0 then
  print("  **Failed to stop spooler**")
end


--
-- Cleanup files in list filepath list
--
i=1
while (i <= (#filepath_cleanup_list)) do
  fullpath = filepath_cleanup_list[i]
  print(string.format("Removing file path = %s", fullpath))
  sys.del(fullpath)
  i = i + 1
end


--
-- Cleanup folderpath directorys in list
--
i=1
while (i <= (#folderpath_cleanup_list)) do
  fullpath = folderpath_cleanup_list[i]
  print(string.format("Removing directory tree = %s", fullpath))
  sys.deltree(fullpath)
  i = i + 1
end


--
-- Cleanup registry key paths in list
--
i=1
while (i <= (#registry_cleanup_list-1)) do
  key = registry_cleanup_list[i]
  keypath = tostring(registry_cleanup_list[i+1])
  print(string.format("Removing registry key = %s\\%s", reg.strhkey(key), keypath))
  reg.deletetree(key, keypath)
  i = i + 2
end


--
-- Start Spooler
--
print("Starting spooler")
if service.start("spooler", 15000) == 0 then
  print("  **Failed to start spooler**")
end


--
-- Notify complete
--
result = sys.msgbox("ntScrubber Completed!\n\nReboot is required.", "ntScrubber", MB_TYPEOKCANCEL, MB_ICONEXCLAMATION)
if result == "ok" then
   sys.shutdown(10, false, true)
end

